package book.beans;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.servlet.http.Part;

/**
 *
 * @author Leonard
 */
@FacesValidator
public class UploadValidator implements Validator {

    private static final Logger logger = Logger.getLogger(UploadValidator.class.getName());

    @Override
    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {

        Part file = (Part) value;

        // WERYFIKACJA DŁUGOŚCI NAZWY PLIKU
        String name = file.getSubmittedFileName();
        logger.log(Level.INFO, "WERYFIKACJA NAZWY PLIKU: {0}", name);
        if (name.length() == 0) {
            FacesMessage message = new FacesMessage("Błąd przesyłania pliku: Nie można określić nazwy pliku!");
            throw new ValidatorException(message);
        } else if (name.length() > 25) {
            FacesMessage message = new FacesMessage("Błąd przesyłania pliku: Nazwa pliku jest zbyt długa!");
            throw new ValidatorException(message);
        }

        // WERYFIKACJA TYPU ZAWARTOŚCI PLIKU
        if ((!"image/png".equals(file.getContentType())) && (!"image/jpeg".equals(file.getContentType()))) {
            FacesMessage message = new FacesMessage("Błąd przesyłania pliku: Można przesyłać tylko obrazy PNG i JPG!");
            throw new ValidatorException(message);
        }

        // WERYFIKACJA WIELKOŚCI PLIKU (rozmiar pliku nie może być większy niż 1 MB)
        if (file.getSize() > 1048576) {
            FacesMessage message = new FacesMessage("Błąd przesyłania pliku: Nie można przesyłać plików większych niż 1 MB!");
            throw new ValidatorException(message);
        }
    }
}
